set sql_safe_updates = 0;
UPDATE sql_dtprovider sd
SET
   sd.sqlQuery = 'SELECT
           bh.id as USER_ID
       FROM
           bill_header bh
        left outer join users u on u.id=bh.studentId
       WHERE
           bh.dueDate = DATE_FORMAT(DATE(NOW()), \'%Y-%m-%d\')
               AND bh.studentId IS NOT NULL
               AND bh.billStatus NOT IN (\'CANCELLED\' , \'SETTLED\')
               AND u.status<>0'
WHERE
   dataProviderId IN (SELECT
           id
       FROM
           dtprovider
       WHERE
           `dataProviderName` = 'OUTSTANDING_BILL_FP_REM_DL');
set sql_safe_updates = 1;